
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.*;

//This is to represent an unweighted undirected graph for the actors

public class ActorsGraph {

	private Map<String, Node> actors;

	public ActorsGraph() {
		actors = new TreeMap<String, Node>(String.CASE_INSENSITIVE_ORDER);
	}

	public void addActor(String actor) {
		Node actorNode = new Node(actor);
		actors.put(actor, actorNode);
	}

	public void addEdge(String actor1, String actor2) {
		Node node1 = actors.get(actor1);
		Node node2 = actors.get(actor2);

		node1.addRelation(node2);
		node2.addRelation(node1);
	}

	public ArrayList<String> shortestPath(String actor1, String actor2) {
		Map<String, String> parents = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
		ArrayList<Node> temp = new ArrayList<Node>();

		Node start = actors.get(actor1);
		temp.add(start);
		parents.put(actor1, null);

		while (temp.size() > 0) {
			Node currentNode = temp.get(0);
			List<Node> knownActors = currentNode.getKnownActors();

			for (int i = 0; i < knownActors.size(); i++) {
				Node nextActor = knownActors.get(i);
				String actorName = nextActor.getName();

				boolean visitedAlready = parents.containsKey(actorName);
				if (visitedAlready) {
					continue;
				}
				else {
					temp.add(nextActor);
					parents.put(actorName, currentNode.getName());

					if (actorName.equalsIgnoreCase(actor2)) {
						return getPath(parents, actor2);
					}
				}
			}
			temp.remove(0);
		}
		return null;
	}

	private ArrayList<String> getPath(Map<String, String> parents, String actor2) {
		ArrayList<String> path = new ArrayList<String>();
		String node = actor2;
		while (node != null) {
			path.add(0, node);
			String parent = parents.get(node);
			node = parent;
		}
		return path;
	}

	private class Node {
		String name;
		List<Node> known = new ArrayList<Node>();

		public Node(String name) {
			this.name = name;
		}

		public String getName() {
			return this.name;
		}

		public void addRelation(Node actor) {
			boolean exist = false;
			for (Node n : known) {
				if (n.getName().equals(actor.getName())) {
					exist = true;
					break;
				}
			}

			if (!exist) {
				known.add(actor);
			}
		}

		public List<Node> getKnownActors() {
			return known;
		}
	}
}